﻿using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Low_Memory_Candy
{
    class Candy
    {
        public Texture2D tex;
        public Vector2 pos;

        public bool isPowerUp = false;

        float rot = 0f;
        float rotUpdate;
        float posm;
        float zoom;


        /// <summary>
        /// Ahh... What am I doing here?
        /// </summary>
        /// <param name="position">Vector2</param>
        /// <param name="texture">Texturh2-d</param>
        /// <param name="scale">Random zoom! Should be at least 1.</param>
        /// <param name="rotation">Rotation</param>
        /// <param name="rotationUpdate">What the rotation of the object increases</param>
        public Candy(Vector2 position, Texture2D texture, float scale, float posIncrease, float rotation, float rotationUpdate)
        {
            this.tex = texture;
            this.pos = position;
            this.zoom = scale;
            this.rot = rotation;
            this.rotUpdate = rotationUpdate;
            this.posm = posIncrease;
        }

        public void update()
        {
            rot += rotUpdate; // Don't worry... There wont be an OutOfRangeException.

            if (rot > 360) rot -= 360;

            pos.Y += posm;
        }

        public void draw(SpriteBatch sb)
        {
            sb.Draw(tex, pos, null, Color.White, (float)(Math.PI * rot / 180), new Vector2(tex.Width / 2, tex.Height / 2), zoom, SpriteEffects.None, 0f);
        }
    }
}
